#include <GL/glut.h>
#include <stdlib.h>
#include <stdio.h>
//
// (x1, y1), (x2, y2), (x3, y3) pontokba rajzol egy hromszget z tvolsgban
// 
void drawTriangle (float x1, float y1, float x2, float y2, float x3, float y3, float z)
	{
   glBegin (GL_TRIANGLES);
   glVertex3f (x1, y1, z);
   glVertex3f (x2, y2, z);
   glVertex3f (x3, y3, z);
   glEnd ();
	}

//
// x1, x2, y1, y2, z1, z2 pozciba rajzol egy drtvz tglatestet
//
void drawViewVolume (float x1, float x2, float y1, float y2, float z1, float z2)
	{
   glColor3f (1.0, 1.0, 1.0);
   glBegin (GL_LINE_LOOP);
   glVertex3f (x1, y1, -z1);
   glVertex3f (x2, y1, -z1);
   glVertex3f (x2, y2, -z1);
   glVertex3f (x1, y2, -z1);
   glEnd ();

   glBegin (GL_LINE_LOOP);
   glVertex3f (x1, y1, -z2);
   glVertex3f (x2, y1, -z2);
   glVertex3f (x2, y2, -z2);
   glVertex3f (x1, y2, -z2);
   glEnd ();
	
   glBegin (GL_LINES);		// 4 egyenes
   glVertex3f (x1, y1, -z1);
   glVertex3f (x1, y1, -z2);
   glVertex3f (x1, y2, -z1);
   glVertex3f (x1, y2, -z2);
   glVertex3f (x2, y1, -z1);
   glVertex3f (x2, y1, -z2);
   glVertex3f (x2, y2, -z1);
   glVertex3f (x2, y2, -z2);
   glEnd ();
}

//
// ngy hromszg s a tglatest kirajzolsa (normal rajzolas)
//
void drawScene (void)
	{
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();
   gluPerspective (40.0, 4.0/3.0, 1.0, 100.0); // perspektvikus lekpzs

   glMatrixMode (GL_MODELVIEW);
   glLoadIdentity ();
   gluLookAt (7.5, 7.5, 12.5, 2.5, 2.5, -5.0, 0.0, 1.0, 0.0);
   
	glColor3f (0.0, 1.0, 0.0);	//  zld hromszg	
   drawTriangle (2.0, 2.0, 3.0, 2.0, 2.5, 3.0, -5.0);
   
	glColor3f (1.0, 0.0, 0.0);	//  piros hromszg	
   drawTriangle (2.0, 7.0, 3.0, 7.0, 2.5, 8.0, -5.0);
   
	glColor3f (1.0, 1.0, 0.0);	//  srga hromszg 2db	
   drawTriangle (2.0, 2.0, 3.0, 2.0, 2.5, 3.0, 0.0);
   drawTriangle (2.0, 2.0, 3.0, 2.0, 2.5, 3.0, -10.0);
   
	drawViewVolume (0.0, 5.0, 0.0, 5.0, 0.0, 10.0);	// tglatest
	}

//
// a szelekcis tmb kiiratsa
//
void processHits (GLint hits, GLuint buffer[])
	{
   int i, j, names;
   GLuint *ptr;

   printf ("talalatok = %d\n", hits);
   ptr = (GLuint *) buffer;
   for (i = 0; i < hits; i++) 
		{	
      names = (int) *ptr;
      printf (" nevek szama a talalaton belul= %d\n", names); ptr++;
		printf("  z1 = %g;", (float) *ptr/0x7fffffff); ptr++;
      printf(" z2  = %g\n", (float) *ptr/0x7fffffff); ptr++;
      printf ("   a nev: ");
      for (j = 0; j < names; j++) 
			{	
         printf ("%d ", *ptr); ptr++;
			}
      printf ("\n");
		}
	}

#define BUFSIZE 512
//
// rajzols szelekcis md esetn
//
void selectObjects(void)
	{
   GLuint selectBuf[BUFSIZE];
   GLint hits;

   glSelectBuffer (BUFSIZE, selectBuf);
   (void) glRenderMode (GL_SELECT);			// a visszatrsi rtk nem rdekes

   glInitNames();
   glPushName(0);

   glPushMatrix ();
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();
   glOrtho (0.0, 5.0, 0.0, 5.0, 0.0, 10.0);	// itt van a csel!
   
	glMatrixMode (GL_MODELVIEW);
   glLoadIdentity ();
		glLoadName(1);
			drawTriangle (2.0, 2.0, 3.0, 2.0, 2.5, 3.0, -5.0);
		glLoadName(2);
			drawTriangle (2.0, 7.0, 3.0, 7.0, 2.5, 8.0, -5.0);
		glLoadName(3);
			drawTriangle (2.0, 2.0, 3.0, 2.0, 2.5, 3.0, 0.0);
		drawTriangle (2.0, 2.0, 3.0, 2.0, 2.5, 3.0, -10.0);   
	glPopMatrix ();
   glFlush ();										// kirajzols

   hits = glRenderMode (GL_RENDER);
   processHits (hits, selectBuf);
	} 

void init () 
	{
   glEnable(GL_DEPTH_TEST);
   glShadeModel(GL_FLAT);
	}

void display(void)
	{
   glClearColor (0.0, 0.0, 0.0, 0.0);
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   drawScene ();
   selectObjects ();
   glFlush();
	}

int main(int argc, char** argv)
	{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH);
   glutInitWindowSize (200, 200);
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init();
   glutDisplayFunc(display);
   glutMainLoop();
   return 0; 
	}
